#include <stdio.h>
#include <string.h>

struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

struct Student students[20];
int numberOfStudents = 0;

void addStudents(int inputs) {
    for (int i = 0; i < inputs; i++) {
        printf("Enter details for student %d:\n", i + 1);
        printf("ID: ");
        scanf("%d", &students[i].id);
        printf("Name: ");
        scanf("%s", &students[i].name);
        printf("Age: ");
        scanf("%d", &students[i].age);
        printf("Address: ");
        scanf("%s", &students[i].address);
    }
    numberOfStudents += inputs;
}

struct Student findStudent(int id) {
    for (int i = 0; i < numberOfStudents; i++) {
        if (students[i].id == id) {
            return students[i];
        }
    }
    return students[0];
}

void printStudentDetails(struct Student student) {
    printf("ID: %d\n", student.id);
    printf("Name: %s\n", student.name);
    printf("Age: %d\n", student.age);
    printf("Address: %s\n", student.address);
}

void main() {
    do{
        printf("Select one of the following options:\n 1. Add students information\n 2. Find and show student details\n 3. Exit\n");
        int option;
        scanf("%d", &option);
        switch (option) {
            case 1:
                int inputs;
                printf("Enter number of students: ");
                scanf("%d", &inputs);
                addStudents(inputs);
                break;
            case 2:
                int id;
                printf("Enter student ID: ");
                scanf("%d", &id);
                struct Student student = findStudent(id);
                printStudentDetails(student);
                break;
            case 3:
                return;
        }
    } while (1);
}